//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------
//
// This is the file you should define your custom datablocks that are to be used
// in the editor.
//

// item datablock

datablock t2dSceneObjectDatablock(itemDatablock) 
{
   class = "item";
   layer = 5; // the render layer
   size = "10 10"; // the size of the object
   // Physics
   immovable = "true";
   maxLinearVelocity = 60;
   constantForce = "0 20";
   //Collision
   CollisionActiveSend = "1";
   CollisionActiveReceive = "0";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCallback = "1";
   CollisionCircleSuperscribed = "0";

   //worldLimit
   WorldLimitCallback = "0";
   WorldLimitMax = "50 37.5";
   WorldLimitMin = "-50 -37.5";
   WorldLimitMode = "BOUNCE";
   //dynamicFields
   itemType = 0;
   itemName = "";
   price = 4;
};

datablock t2dSceneObjectDatablock(itemCmptDatablock) 
{
   class = "itemCmpt";
   //layer = 5; // the render layer
   //size = "10 10"; // the size of the object
   // Physics
   immovable = "true";
   maxLinearVelocity = 80;
   constantForce = "0 20";
   //Collision
   CollisionActiveSend = "1";
   CollisionActiveReceive = "1";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCircleSuperscribed = "0";
   CollisionCallback = "1";
   //worldLimit
   WorldLimitCallback = "0";
   WorldLimitMax = "50 37.5";
   WorldLimitMin = "-50 -37.5";
   WorldLimitMode = "BOUNCE";
   //dynamicFields
   cmptName = "e";
   itemName = "e";
   //isPlaced = 1;
};

datablock t2dSceneObjectDatablock(itemPinsDatablock) 
{
   class = "item";
   layer = "24"; // the render layer
   size = "1.1 1.1"; // the size of the object
   // Physics
   immovable = "true";
   maxLinearVelocity = 60;
   constantForce = "0 20";
   //Collision
   CollisionActiveSend = "1";
   CollisionActiveReceive = "0";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCallback = "1";
   CollisionCircleSuperscribed = "0";

   //worldLimit
   WorldLimitCallback = "0";
   WorldLimitMax = "50 37.5";
   WorldLimitMin = "-50 -37.5";
   WorldLimitMode = "BOUNCE";
   //dynamicFields
   itemType = 0;
   itemName = "pins_";
   itemImage = "pins_";
   price = 2;
   isPlaced = 1;
   noFlip = 1;
};

datablock t2dSceneObjectDatablock(itemBalloonDatablock) 
{
   class = "item";
   layer = 5; // the render layer
   size = "10 10"; // the size of the object
   // Physics
   immovable = "true";
   maxLinearVelocity = 60;
   constantForce = "0 20";
   //Collision
   CollisionActiveSend = "1";
   CollisionActiveReceive = "0";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCallback = "1";
   CollisionCircleSuperscribed = "0";

   //worldLimit
   WorldLimitCallback = "0";
   WorldLimitMax = "50 37.5";
   WorldLimitMin = "-50 -37.5";
   WorldLimitMode = "BOUNCE";
   //dynamicFields
   itemType = 0;
   //itemName = "";
   price = 3;
   altGrav = 1;
   noFlip = 1;
};

datablock t2dSceneObjectDatablock(itemRingDatablock) 
{
   class = "item";
   layer = 5; // the render layer
   size = "0.5 0.5"; // the size of the object
   // Physics
   immovable = "true";
   maxLinearVelocity = 60;
   constantForce = "0 20";
   //Collision
   CollisionActiveSend = "1";
   CollisionActiveReceive = "0";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCallback = "1";
   CollisionCircleSuperscribed = "0";

   //worldLimit
   WorldLimitCallback = "0";
   WorldLimitMax = "50 37.5";
   WorldLimitMin = "-50 -37.5";
   WorldLimitMode = "BOUNCE";
   //dynamicFields
   itemType = 0;
   price = 35;
   noFlip = 1;
   itemName = "";
   itemImage = "";
   isPlaced = 1;
};

datablock t2dSceneObjectDatablock( respawnTargetDatablock )
{
   class = "respawnTarget"; // the class that will be associated with the object
   layer = 2; // the render layer
   size = "20 5"; // the size of the object
};

datablock t2dSceneObjectDatablock( peopleDatablock )
{
   class = "people"; // the class that will be associated with the object
   layer = 2; // the render layer
   size = "10 10"; // the size of the object
   isOccupied = false;
   CollisionActiveReceive = "1";
   CollisionPhysicsSend = "0";
   CollisionPhysicsReceive = "0";
   CollisionCallback = "1";
   
};

datablock t2dSceneObjectDatablock( shadowDatablock )
{
   class = "shadow"; // the class that will be associated with the object
   layer = 30; // the render layer
   mountInheritAttributes  = "true";
};

